﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Clean.master" AutoEventWireup="true" CodeBehind="Login.aspx.cs" Inherits="GUI.Login" %>

<asp:Content ID="Content3" ContentPlaceHolderID="StylePlaceholder" runat="server">
    	<link href="repository/theme/assets/pages/css/login.css" rel="stylesheet" media="screen" />
        <style>
            .login .page-wrapper .page-wrapper-middle {
                background:none !important;
            }
            @media only screen and (max-width: 600px) {
                #forget-password {
                    width:100% !important;
                    margin-bottom: 10px;
                }

                .login-button{
                    float: none;
                    width: 100% !important;
                }
            }
        </style>
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="CleanContentPlaceHolder" runat="server">
    
    <div class="logo">
            <a href="Login.aspx">
            <img src="repository/theme/img/kendo-logo-white.png" alt="Project Management System" title="Project Management System" height="70"/> </a>
    </div>
            
           <asp:Login ID="lgnUser" runat="server" CssClass="content login-tbl" onauthenticate="lgnUser_Authenticate" DisplayRememberMe="false" FailureText="<%$ Resources:ProjectManagementUI, Login_Failed %>" DestinationPageUrl="~/Default.aspx">
				<LayoutTemplate>
                        <div class="content">
                                <h3 class="form-title font-blue"><asp:Literal ID="ltr1" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_UserLogin %>" /></h3>
                                <div class="alert alert-danger display-hide">
                                    <button class="close" data-close="alert"></button>
                                    <span class="login-alert"><asp:Literal ID="FailureText" runat="server" EnableViewState="False"></asp:Literal></span>
                                </div>
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Username %>" /></label>
                                    <asp:TextBox ID="UserName" placeholder="<%$ Resources:ProjectManagementUI, Common_Username %>" autocomplete="off" runat="server" CssClass="form-control form-control-solid placeholder-no-fix"></asp:TextBox>
                                    <span class="help-block font-red">
                                        <asp:RequiredFieldValidator ID="UserNameRequired" runat="server" Display="Dynamic" CssClass="vError" SetFocusOnError="true"
                                            ControlToValidate="UserName" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" ValidationGroup="lgnUser">
                                            *<asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" />
                                        </asp:RequiredFieldValidator>
                                    </span>
                                </div>
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Password %>" /></label>
                                    <asp:TextBox ID="Password" placeholder="<%$ Resources:ProjectManagementUI, Common_Password %>" autocomplete="off" runat="server" TextMode="Password" CssClass="form-control form-control-solid placeholder-no-fix"></asp:TextBox>
                                    <span class="help-block font-red">
                                        <asp:RequiredFieldValidator ID="PasswordRequired" runat="server"  Display="Dynamic" CssClass="vError" SetFocusOnError="true"
											ControlToValidate="Password" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" 
											ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" ValidationGroup="lgnUser">
                                            *<asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" />
                                       </asp:RequiredFieldValidator>
                                    </span>
                                </div>
                                <div class="form-actions">
                                    <a href="ForgottenPassword.aspx" id="forget-password" class="btn blue btn-outline"><asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_ForgottenPassword %>" /></a>
                                    <asp:Button ID="LoginButton" runat="server" CommandName="Login" CssClass="btn login-button blue uppercase pull-right" Text="<%$ Resources:ProjectManagementUI, Common_Login %>" ValidationGroup="lgnUser" />
                                </div>
                        </div>	
				</LayoutTemplate>
			</asp:Login>
			<div class="licence-validation text-center hidden">
				<asp:Label ID="Label1" runat="server" ForeColor="White" CssClass="valid-licence"/>
			    <asp:HiddenField ID="hdnField1" runat="server" /><asp:HiddenField ID="hdnField2" runat="server" /><asp:HiddenField ID="hdnField3" runat="server" /><asp:HiddenField ID="hdnField4" runat="server" />
			</div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
    	<script type="text/javascript">
	       /* window.onload = RedirectIfInRadWindow();

	        function RedirectIfInRadWindow() {
	            var rWnd = GetRadWindow();

	            if (rWnd != null) {
	                // redirect parent page to current url
	                rWnd.BrowserWindow.location = window.location;
	                // close RadWindow
	                rWnd.close();
	            }
	            Sys.Application.remove_load(RedirectIfInRadWindow);
	        }

	        function GetRadWindow() {
	            var oWindow = null;

	            if (window.radWindow) {
	                oWindow = window.radWindow;
	            }
	            else if (window.frameElement.radWindow) {
	                oWindow = window.frameElement.radWindow;
	            }
	            return oWindow;
	        }*/
    	    $(document).ready(function () {
    	        if ($('.login-alert').text().length == 0) {
    	            $(".alert-danger").addClass("display-hide")
    	        }
    	        else {
    	            $(".alert-danger").removeClass("display-hide")
    	        }

    	        if ($('.valid-licence').text().length == 0) {
    	            $(".licence-validation").addClass("hidden")
    	        }
    	        else {
    	            $(".licence-validation").removeClass("hidden")
    	        }

	            $("#MainContentPlaceHolder_CleanContentPlaceHolder_lgnUser_UserName").focus();
	        });

	        function validate() {
	            return document.forms[0].valid();
	        }
	</script>
 </asp:Content>